## ************************************************************************************************
## expandCellCountTable function definition
## ----------------------------------------
##
## Purpose: Internal function of plotWoodFormationDynamics
##  - used for expanding cell count tables so that all the missing values are coded explicitly with NA.
##
## Arguments:
##   - data: a data.frame with imposed column names:
##      Site, Year, Tree, Species, Sample, DY, CZ, EZ, WZ, MZ, PR;
##      RF can be either present (table containing raw data) or
##      absent (table containing aggregated data).
##
## Outputs:
##   - a data.frame with the same structure as the argument.
##
## Versions:
##  	1.0-0. Defining this new function.
##   	1.0-1. Changing the names of the input variables.
##
## Started: 13 June 2014
## Last modifications: 30 June 2016
## Author: Cyrille RATHGEBER - LERFoB UMR1092 - INRA Nancy
##
## ------------------------------------------------------------------------------------------------

expandCellCountTable <- function(data) {
   
   # message("--> Entering expandCellCountTable function...")
   IDF <- data

   ## Selecting which form of the function to use depending on the structure of the input dataframe
   ## =============================================================================================

   IDF.col.names <- names(IDF)

   ## For tables, which do contain radial files (RF)
   ## ----------------------------------------------
   if ("RF" %in% IDF.col.names == TRUE) {
      Exp.Lst <- by(IDF, list(Site=IDF$Site, Year=IDF$Year, Species=IDF$Species), expandCCT.RF)
      EDF <- do.call(rbind, Exp.Lst)
   }

   ## For tables, which do not contain radial files (RF)
   ## --------------------------------------------------
   if ("RF" %in% IDF.col.names == FALSE) {
      Exp.Lst <- by(IDF, list(Site=IDF$Site, Year=IDF$Year, Species=IDF$Species), expandCCT.Tree)
      EDF <- do.call(rbind, Exp.Lst)
   }

   ## Returning the expanded data frame
   return(EDF)

} ## End of expandCellCountTable function

## ------------------------------------------------------------------------------------------------
##                           End expandCellCountTable function
## ************************************************************************************************
