## ************************************************************************************************
## getGompertzCoefficients.IUF function definition
## -----------------------------------------------
##
## Purpose: Internal utilitary function of fitGompertzModels and plotGompertz.Group
##  - used for extracting a data frame of coeficients from a list of Gompertz parameters
##
## Arguments:
##   - input.list: a list of Gompertz parameters, typically output from fitGompertz function
##
## Outputs:
##   - ODF: a data frame containing Gompertz coefficients
##
## Versions:
##		1.1-0. Defining this new function (15/11/2016)
##		1.1-1. Checking this new function (21/11/2016)
##    2.1-2. Improvement and homogeneisation (12/04/2017)
##
## Started: 15 November 2016
## Last modifications: 12 April 2017
## Author: Cyrille RATHGEBER - INRA Nancy
##
## ------------------------------------------------------------------------------------------------

getGompertzCoefficients.IUF <- function(input.list) {
   
   # message("--> Entering getGompertzCoefficients.IUF function...")
   
   ## Defining an utilitary function to get the coefficients for one element of the list
   ## ----------------------------------------------------------------------------------
   getGompertzCoef <- function(list.element) { 
      DF <- as.data.frame(list.element$coefficients)
      Site <- as.character(list.element$references[1])
      Year <- as.character(list.element$references[2])
      Species <- as.character(list.element$references[3])
      Tree <- as.character(list.element$references[4])
      ODF <- data.frame(Site, Year, Species, Tree, DF)
      ODF$Type <- as.factor(ODF$Type)
      return(ODF)
   }
   
   ## Extracting the fitting coefficients from all the elements of the input list
   CLST <- lapply(input.list, getGompertzCoef)
   
   ## Creating and returning the output data.frame
   ODF <- as.data.frame(do.call(rbind, CLST))
   return (ODF)
   
} ## End function getGompertzCoefficients.IUF

## ------------------------------------------------------------------------------------------------
##                           End getGompertzCoefficients.IUF function
## ************************************************************************************************