## ************************************************************************************************
## getWoodGrowthSimulations.IUF function definition
## ------------------------------------------------
##
## Purpose: Internal utilitary function of plotWoodGrowth, plotGompertz.CT, and plotGompertz.Comp
##  - used for extracting a data frame containing wood growth simulations
##     from the output list of fitGompertzModels (future fitGrowthModels)
##
## Arguments:
##   - input.list: a list of model outputs, typically from fitGompertzModels
##                  (future fitGrowthModels) function
##
## Outputs:
##   - ODF: a data frame containing wood growth model simulations
##
## Versions:
##		1.1-0. Defining this new function (25/11/2016)
##		1.1-1. Checking this new function (29/11/2016)
##    1.1-2. Improvement and homogeneisation (12/04/2017)
##
## Started: 25 November 2016
## Last modifications: 12 April 2017
## Author: Cyrille RATHGEBER - INRA Nancy
##
## ------------------------------------------------------------------------------------------------

getWoodGrowthSimulations.IUF <- function(input.list) {
   
   # message("--> Entering getWoodGrowthSimulations.IUF function...")
   
   ## Defining an utilitary function to get the values for one element of the list
   ## ----------------------------------------------------------------------------
   getWoodGrowthSim <- function(list.element) { 
      DF <- as.data.frame(list.element$simulations)
      Site <- as.character(list.element$references[1])
      Year <- as.character(list.element$references[2])
      Species <- as.character(list.element$references[3])
      Tree <- as.character(list.element$references[4])
      EDF <- data.frame(Site, Year, Species, Tree,
                        DY=DF$DY, EWMZ=DF$EWMZ.sim, WMZ=DF$WMZ.sim, MZ=DF$MZ.sim)
      return(EDF)
   }
   
   ## Extracting the simulations from all the elements of the input list
   CLST <- lapply(input.list, getWoodGrowthSim)
   
   ## Creating and returning the output data.frame
   ODF <- as.data.frame(do.call(rbind, CLST))
   return (ODF)
   
} ## End function getWoodGrowthSimulations.IUF

## ------------------------------------------------------------------------------------------------
##                           End getWoodGrowthSimulations.IUF function
## ************************************************************************************************