## ************************************************************************************************
## plotDateMark.IUF function definition
## -----------------------------------
##
## Purpose: Internal utilitary function of plotWoodFormationCalendar
##  - used for drawing a play mark
##
## Arguments:
##    - first.mark.x: x position of the first mark
##    - last.mark.x: x position of the last mark
##    - day.of.year: y position of the dates
##    - color: color of the signs
##    - band.width: optional parameter for horizontal bar width
##    - line.width: optional parameter for horizontal line width
##
## Outputs:
##    - none
##
## Versions:
##		1.0-0. Defining this new function
##
## Started: 5 July 2016
## >>> Last modifications: 12 September 2016
## Author: Cyrille RATHGEBER - INRA Nancy
##
## ------------------------------------------------------------------------------------------------

plotDateMark.IUF <- function(first.mark.x, last.mark.x, day.of.year,
                             color = "black", band.width = 0.25, line.width = 2) {
   
   #message("--> Entering plotDateMark.IUF function...")
   
   X <- c(first.mark.x[2], first.mark.x[3], first.mark.x[4], first.mark.x[3])
   Y <- c(day.of.year, day.of.year + band.width, day.of.year, day.of.year - band.width)
   lines(c(first.mark.x[1], first.mark.x[5]), c(day.of.year, day.of.year), col=color, lwd=line.width)
   polygon(X, Y, density=NA, col=color, border=color, lwd=line.width)
   
   X <- c(last.mark.x[2], last.mark.x[3], last.mark.x[4], last.mark.x[3])
   Y <- c(day.of.year, day.of.year + band.width, day.of.year, day.of.year - band.width)
   lines(c(last.mark.x[1], last.mark.x[5]), c(day.of.year, day.of.year), col=color, lwd=line.width)
   polygon(X, Y, density=NA, col=color, border=color, lwd=line.width)
   
} # End plotDateMark.IUF function


## ------------------------------------------------------------------------------------------------
##                           End plotDateMark.IUF function
## ************************************************************************************************