## ************************************************************************************************
## plotDurationBar.IUF function definition
## -----------------------------------------
##
## Purpose: Internal utilitary function of plotWoodFormationCalendar
##  - used for drawing a duration bar
##
## Arguments:
##   - bar.x: numeric vector containing x coordinates for drawing the bar
##   - bar.y: y position of the bar
##   - color: color of the bar
##   - bar.width: optional parameter for horizontal bar width
##   - line.width: optional parameter for horizontal line width
##
## Outputs:
##   - none
##
## Versions:
##		1.0-0. Defining this new function
##
## Started: 5 July 2016
## >>> Last modifications: 12 September 2016
## Author: Cyrille RATHGEBER - INRA Nancy
##
## ------------------------------------------------------------------------------------------------

plotDurationBar.IUF <- function(bar.x, bar.y,
                                color = "black", bar.width = 0.25, line.width = 2) {
   
   #message("--> Entering plotDurationBar.IUF function...")

   X <- c(0, bar.x[3], bar.x[3], 0)
   Y <- c(bar.y + bar.width, bar.y + bar.width, bar.y - bar.width, bar.y - bar.width)
   polygon(X, Y, density=NA, col=color, border=color, lwd=line.width)
   lines(c(bar.x[1], bar.x[3]), c(bar.y, bar.y), col="white", lwd=line.width)
   lines(c(bar.x[2], bar.x[2]), c(bar.y - 0.25*bar.width, bar.y + 0.25*bar.width), col="white", lwd=line.width)
   lines(c(bar.x[3], bar.x[5]), c(bar.y, bar.y), col=color, lwd=line.width)
   lines(c(bar.x[4], bar.x[4]), c(bar.y - 0.25*bar.width, bar.y + 0.25*bar.width), col=color, lwd=line.width)
   
} # End of plotDurationBar.IUF function

## ------------------------------------------------------------------------------------------------
##                           End plotDurationBar.IUF function
## ************************************************************************************************