## ************************************************************************************************
## plotEmptyCDC() function definition
## --------------------------------
##
## Internal function for handling the case where there is no data to plot!
## 
## Arguments:
##    - plot.type: a character containing the label for the plot
##
## Outputs:
##		- A single plot with "No data available" written on it
##    - A vector containing the values for the lower and upper fences
##
## Versions :
##		1.0.0. 2016-06-24 --- Function developement started
##
## Started: 24 June 2016
## Last modifications:  24 June 2016
## Author: Cyrille RATHGEBER - INRA Nancy
## ================================================================================================

plotEmptyCDC <- function(x, plot.type) {
   
   # message("--> Entering plotEmptyCDC function...")
   
   ## Gathering information of x vector
   ## ---------------------------------
   X <- rep(1, times = length(x))
   Y <- 1:length(x)
   L <- seq(0, max(X), 1)
   
   ## Drawing the plot region
   ## -----------------------
   plot(X, Y, type = "n", axes=FALSE, ann=FALSE, xlim = c(0, 25))
   #axis(1)
   axis(2)
   mtext(plot.type, side=3, line=0.1, adj=0)
   box()
   
   ## Writing the warning
   ## -------------------
   text(5, median(Y), labels = "No data to plot!", pos = 4, col = "red", cex = 3)

   
} # End Function plotEmptyCDC
## ************************************************************************************************ 