## ************************************************************************************************
## plotPlayMark.IUF function definition
## -----------------------------------
##
## Purpose: Internal utilitary function of plotWoodFormationCalendar
##  - used for drawing a play mark
##
## Arguments:
##   - mark.x: position of the tip of the mark in x
##   - mark.y: position of the base of the mark in x
##   - mark.y: position of the mark in y
##   - direction: direction of the mark
##   - color: color of the sign
##   - mark.size.x: optional parameter for adjusting the size of the mark in x
##   - mark.size.y: optional parameter for adjusting the size of the mark in y
##
## Outputs:
##   - none
##
## Versions:
##		1.0-0. Defining this new function
##
## Started: 5 July 2016
## Last modifications: 12 Septembre 2016
## Author: Cyrille RATHGEBER - INRA Nancy
##
## ------------------------------------------------------------------------------------------------

plotPlayMark.IUF <- function(mark.x, mark.y, mark.size.x = 5,
                              direction = "right", color = "black" , mark.size.y = 0.5) {
   
   #message("--> Entering plotPlayMark.IUF function...")

   if (direction == "left")	{
      X <- c(mark.x - mark.size.x, mark.x + mark.size.x, mark.x + mark.size.x)
      Y <- c(mark.y, mark.y + mark.size.y, mark.y - mark.size.y)
      polygon(X, Y, density=NA, col=color)
   }
   
   if (direction == "right")	{
      X <- c(mark.x + mark.size.x, mark.x - mark.size.x, mark.x - mark.size.x)
      Y <- c(mark.y, mark.y + mark.size.y, mark.y - mark.size.y)
      polygon(X, Y, density=NA, col=color)
   }
   
} # End plotPlayMark.IUF function

## ------------------------------------------------------------------------------------------------
##                           End plotPlayMark.IUF function
## ************************************************************************************************