## ************************************************************************************************
## scalingYAxis.IUF function definition
## -----------------------------------
##
## Purpose: Internal utilitary function of plotWFD.RF, plotWFD.TR, plotWFD.GR, and plotWFD.TD
##  - used for defining an adapted y axis scale for these plots
##
## Arguments:
##   - y: maximal value of the y axis
##
## Outputs:
##   - z: the scaling value to use
##
## Versions:
##		1.1-0. Defining this new function (5/07/2016)
##		1.2-0. Changing the name of the function (10/10/2016)
##		1.2-1. Chompleting the function (10/04/2017)
##
## Started: 5 July 2016
## Last modifications: 10 April 2017
## Author: Cyrille RATHGEBER - INRA Nancy
##
## ------------------------------------------------------------------------------------------------

scalingYAxis.IUF <- function(y){
   
   # message("--> Entering scalingYAxis.UF function...")
   if (y <= 1 ) return(0.2)
   if (y > 1  & y <= 6 ) return(1)
   if (y > 6  & y <= 13 ) return(2)
   if (y > 13 & y <= 26) return(5)
   if (y > 26 & y <= 61) return(10)
   if (y > 61 & y <= 126) return(25)
   if (y > 126 & y <= 201) return(50)
   if (y > 201 & y <= 501) return(100)
   if (y > 501 & y <= 1001) return(250)
   if (y > 1001) return(500)
   if (y > 126) return(50)
   
} ## End function scalingYAxis.IUF

## ------------------------------------------------------------------------------------------------
##                           End scalingYAxis.IUF function
## ************************************************************************************************