\name{GRA}

\docType{data}

\alias{GRA}

\title{GRA cell count table}

\description{
 This dataset was obtained from a cambial activity and wood formation monitoring study (Cuny et al. 2012).
 Data were collected weekly from 2007 to 2009 for 5 silver firs, 5 Norway spruces, and 5 Scots pines grown
 in the same stand, located in Grandfontaine forest (Donon mountain, North of Vosges), 
 near Nancy (northeast France). \cr
 Column "Site" indicates the code of the site. \cr
 Column "Year" indicates the code of the year of sampling. \cr
 Column "Species" indicates the tree species code (according to ITRDB). \cr
 Column "Tree" indicates the tree reference number. \cr
 Column "Sample" indicates the sampling campaign reference number. \cr
 Column "DY" indicates the date of the sampling in day of year. \cr
 Column "RF" indicates the radial file reference number. \cr
 Column "CZ" gives the number of cells in the cambial zone. \cr
 Column "EZ" gives the number of cells in the enlarging zone. \cr
 Column "WZ" gives the number of cells in the maturing zone. \cr
 Column "MZ" gives the number of mature cells. \cr
 Column "PR" gives a measure (in number of cells, expression(mu) or mm) of the previous tree-ring width. \cr
}

\usage{GRA}

\format{A dataframe containing 12 columns and 4339 rows}

\source{
   Cyrille Rathgeber - LERFoB, INRA, AgroParisTech, F-54000, Nancy, France \cr
   Email: \email{cyrille.rathgeber@inra.fr}
}

\references{
 Cuny H.E., Rathgeber C.B.K., Lebourgeois F., Fortin M. & Fournier M. 2012.
 Life strategies in intra-annual dynamics of wood formation: example of three conifer species in a
 temperate forest in north-east France. \emph{Tree Physiology} \bold{32}: 612-625. \cr
}

\seealso{
 \code{
  \link{aggregateRadialFiles},
  \link{computeBootstrapTest},
  \link{computeCriticalDates},
  \link{computeGompertzCellTimings},
  \link{computeRingCellNb},
  \link{fitGompertzModels},
  \link{expandCellCountTable},
  \link{overviewCellCountTable},
  \link{plotCleavelandDotChart},
  \link{plotWoodFormationCalendar},
  \link{plotWoodFormationDynamics},
  \link{plotWoodGrowth},
  \link{readExcelCountTable},
  \link{standardiseCellCounts}
  }
}

\note{
 Version: 1.2-3. \cr
 Development started: 4 May 2009. \cr
 Last modifications: 10 January 2017.
}

\keyword{datasets}
