\name{aggregateRadialFiles}

\alias{aggregateRadialFiles}

\title{aggregateRadialFiles}

\description{
 Aggregates raw radial files data to compute median or mean cell numbers per tree.
}

\usage{
 aggregateRadialFiles(data, stat = "median")
}


\arguments{
  \item{data}{a data.frame containing cell count data. This data frame must contain 12 imposed variables
   with compulsory column names: Site, Year, Tree, Species, Sample, DY, RF, CZ, EZ, WZ, MZ, 
   and PR (see \code{\link{GRA}}).
   }
  \item{stat}{an optional character string indicating if RF file should be aggregated using
   "median" (default) or "mean".
   }
}

\details{
 This function takes the raw cell count data (CZ, EZ, WZ, MZ, and PR) recorded by radial file
  and aggregate (using median or mean) them tree by tree / year. \cr
 Additionally, it computes the sums of mature and thickening cells (WMZ = WZ + MZ); and mature, thickening,
  and enlarging cells (EWMZ = EZ + WZ + MZ). \cr
}

\value{
 A data frame of at 13 columns containing:
  the unchanged group variables: Site, Year, Species, Tree, Sample, and DY; \cr
  and the aggregated values for variables: CZ, EZ, WZ, MZ, and PR; \cr
  along with the cumulative sums WMZ and EWMZ. \cr
}

\note{
 Version: 3.1-2. \cr
 Development started: 27 November 2008. \cr
 Last modifications: 29 September 2016.
}

\author{
 Cyrille Rathgeber - LERFoB, UMR1092 - INRA Nancy (France) \cr
 Email: \email{cyrille.rathgeber@inra.fr}
}

\references{
 Rathgeber C.B.K., Longuetaud F., Mothe F., Cuny H. & Le Moguedec G. 2011.
 Phenology of wood formation: Data processing, analysis and visualisation using R (Package CAVIAR).
 \emph{Dendrochronologia} \bold{29}: 139-149. \cr
}

\seealso{
 \code{
  \link{computeBootstrapTest},
  \link{computeCriticalDates},
  \link{computeGompertzCellTimings},
  \link{computeRingCellNb},
  \link{expandCellCountTable},
  \link{fitGompertzModels},
  \link{GRA},
  \link{overviewCellCountTable},
  \link{plotCleavelandDotChart},
  \link{plotWoodFormationCalendar},
  \link{plotWoodFormationDynamics},
  \link{plotWoodGrowth},
  \link{readExcelCountTable},
  \link{standardiseCellCounts}
  }
}

\examples{
 ## Loading the training dataset:
 data(GRA)

 ## Computing the median for Grandfontaine raw data:
 GRA.median <- aggregateRadialFiles(data=GRA, stat="median")

 ## Computing the mean for Grandfontaine raw data:
 GRA.mean <- aggregateRadialFiles(data=GRA, stat="mean")
 
 ## Creating a csv file containing the aggregated dataset
 write.csv2(GRA.median, file = paste("GRA median - ", Sys.Date(), ".csv", sep=""), row.names = FALSE)
}

\keyword{datagen}
