\name{computeBootstrapTest}
\alias{computeBootstrapTest}

\title{computeBootstrapTest}

\description{
 Computes bootstrap tests for comparing two groups of trees.
}

\usage{
 computeBootstrapTest(data.group1, data.group2, ci.group1 = NA, ci.group2 = NA,
                      stat = "median", centring = FALSE, iter = 1000, out = FALSE,
                      plot = FALSE, main = "NULL", var.name = "?", sub = "NULL")
}


\arguments{
 \item{data.group1}{a vector containing data for the first group}
 \item{data.group2}{a vector containing data for the second group}
 \item{ci.group1}{an optional vector containing standard deviations for the first group}
 \item{ci.group2}{an optional vector containing standard deviations for the second group}
 \item{stat}{the method to be used: \cr
   "mean" for mean comparison;\cr
   "Student" for mean comparison using Student's t statistic;\cr
	"median" for median comparison (default);\cr
	"var" for variance comparison;\cr
	"disp.mean" for dispersion around the mean comparison;\cr
	"disp.median" for dispersion around the median comparison.
 }
 \item{centring}{an optional logical indicating if data must be centred or not (default=FALSE)}
 \item{iter}{an optional integer indicating the number of iterations for the bootstrap (default=1000)}
 \item{out}{an optional logical indicating if bootstrapped series must be outputted or not (default=FALSE)}
 \item{plot}{an optional logical indicating if a plot must be outputted or not (default=FALSE)}
 \item{main}{an optional character containing the title of the plot}
 \item{var.name}{an optional character labeling the variable to be tested}
 \item{sub}{an optional character containing the plot sub-title}
}

\details{
 Computes unilateral bootstrap permutation tests for testing equality of mean, median, or variance between
 two groups of trees. \cr
 Several test statistics can be used: mean difference, Studentized mean difference, median difference,
 logarithm ratio of variance, dispersion around the mean ratio and dispersion around the median ratio. \cr
 For test statistics based on the mean, data can be centred. \cr
 Moreover this function can also be feed with two additional vectors containing standard deviations around
 the critical dates in order to take dispersion into account.
 It can plot (option{plot}) an histogram of the bootstrap distribution of the tested statistic along with
 its observed value.
}

\value{
 A list containing the results of the test:\cr
 \item{summary}{Summary of the test}
 \item{ASL}{Signification level of the test}
 \item{ts.obs}{Observed value of the tested statistic (\option{out=TRUE})}
 \item{iterations}{number of iterations (\option{out=TRUE})}
 \item{nb.combinations}{number of possible combinations (\option{out=TRUE})}
 \item{ts}{bootstrap series (\option{out=TRUE})}
}

\section{Warning }{
 Dispersion is not implemented for tests based on centred statistics (\option{centring=TRUE})!
}

\note{
 Version: 5.1-1 \cr
 Development started: 14 July 2009. \cr
 Last modifications: 22 September 2016.
}

\author{
 Cyrille Rathgeber - LERFoB, UMR1092 - INRA Nancy (France) \cr
 Email: \email{cyrille.rathgeber@inra.fr}
}

\references{
 Rathgeber C.B.K., Longuetaud F., Mothe F., Cuny H. & Le Moguedec G. 2011.
 Phenology of wood formation: Data processing, analysis and visualisation using R (Package CAVIAR).
 \emph{Dendrochronologia} \bold{29}: 139-149. \cr
}

\seealso{
 \code{
  \link{aggregateRadialFiles},
  \link{computeCriticalDates},
  \link{computeGompertzCellTimings},
  \link{computeRingCellNb},
  \link{fitGompertzModels},
  \link{expandCellCountTable},
  \link{GRA},
  \link{overviewCellCountTable},
  \link{plotCleavelandDotChart},
  \link{plotWoodFormationCalendar},
  \link{plotWoodFormationDynamics},
  \link{plotWoodGrowth},
  \link{readExcelCountTable},
  \link{standardiseCellCounts}
  }
}

\examples{
 ## Loading the example dataset:
 data(GRA)

 ## Computing wood formation critical dates for firs, spruces, and pines in 2009:
 GRA2009 <- GRA[GRA$Year==2009, ]
 
 Fir2009 <- GRA2009[GRA2009$Sp=="ABAL", ]
 Spruce2009 <- GRA2009[GRA2009$Sp=="PCAB", ]
 Pine2009 <- GRA2009[GRA2009$Sp=="PISY", ]
 
 Fir.cd <- computeCriticalDates(Fir2009, plot = TRUE)
 Spruce.cd <- computeCriticalDates(Spruce2009, plot = TRUE)
 Pine.cd <- computeCriticalDates(Pine2009, plot = TRUE)
 
 ## Testing if fir start xylogenesis before spruce
 computeBootstrapTest(Fir.cd$bE, Spruce.cd$bE)
 
 ## Testing if fir starts xylogenesis before spruce with taking dispersion into account
 computeBootstrapTest(Fir.cd$bE, Spruce.cd$bE, Fir.cd$bE.ci, Spruce.cd$bE.ci)
 
 ## Plotting the test
 computeBootstrapTest(Fir.cd$bE, Spruce.cd$bE, Fir.cd$bE.ci, Spruce.cd$bE.ci, plot=TRUE)
}

\keyword{htest}
\keyword{nonparametric}
\keyword{hplot}
