\name{computeCriticalDates}
\alias{computeCriticalDates}

\title{computeCriticalDates}

\description{
 Computes wood formation critical dates and durations along with associated confidence intervals
}

\usage{
 computeCriticalDates(data, plot=TRUE)
}


\arguments{
  \item{data}{a data frame containing cell count data.
   This data frame must contain at least 7 imposed columns with compulsory names:
   Tree, DY, RF, CZ, EZ, WZ, MZ (see \code{\link{GRA}})}
  \item{plot}{an optional logical indicating if a PDF of the verification plots must be printed (default=TRUE)}
}

\details{
 This function computes wood formation critical dates and durations from a raw data table containing cell
 counts (for each radial file) for the 4 development phases (cambial, enlargement, wall thickening, and mature) per
 sampling dates (see \code{\link{GRA}}). \cr
 Five critical dates as well as their associated confidence intervals are computed using logistic regressions
 \code{\link{glm}}, the main date corresponds to the 50\% probability of the investigated phase being active while
 the 95\% confidence interval limits corresponds to the 2.5 and 97.5\% probabilities. \cr
 From the five critical dates, the function computes three critical durations along with their associated
 confidence intervals (assuming independence between dates). \cr
 By default (\option{plot=TRUE}), the function outputs a PDF of the verification plots entitled
 \file{Verification plots for computation of critical dates... .pdf},
 illustrating the computation of each critical date for a quick visual checking.
}

\value{
 A data frame containing the five dates and the three durations along with their associated confidence intervals. \cr
 Critical dates are: \cr
   \item{bE}{begining of Enlargement period;}
   \item{bW}{begining of Wall thickening period;}
   \item{bM}{begining of Mature period;}
   \item{cE}{cessation of Enlargement period;}
   \item{cW}{cessation of Wall thickening period.} \cr
 Critical durations are: \cr
   \item{dE}{duration of Enlargement period (dE = cE - bE);}
   \item{dW}{duration of Wall thickening period (dW = cW - bW);}
   \item{dX}{total duration of wood formation period (dX = cW - bE).}
}

\note{
 Version: 4.2-1. \cr
 Development started: 21 October 2009. \cr
 Last modifications: 07 Septembre 2016.
}

\author{
 Cyrille Rathgeber - LERFoB, UMR1092 - INRA Nancy (France) \cr
 Email: \email{cyrille.rathgeber@inra.fr}
}

\references{
 Rathgeber C.B.K., Longuetaud F., Mothe F., Cuny H. & Le Moguedec G. 2011.
 Phenology of wood formation: Data processing, analysis and visualisation using R (Package CAVIAR).
 \emph{Dendrochronologia} \bold{29}: 139-149. \cr

 Rathgeber C.B.K., Rossi S.& Bontemps J.-D. 2011.
 Cambial activity related to tree size in a mature silver-fir plantation.
 \emph{Annals of Botany} \bold{108}: 429-438.
}

\seealso{
 \code{
  \link{aggregateRadialFiles},
  \link{computeBootstrapTest},
  \link{computeGompertzCellTimings},
  \link{computeRingCellNb},
  \link{expandCellCountTable},
  \link{fitGompertzModels},
  \link{GRA},
  \link{overviewCellCountTable},
  \link{plotCleavelandDotChart},
  \link{plotWoodFormationCalendar},
  \link{plotWoodFormationDynamics},
  \link{plotWoodGrowth},
  \link{readExcelCountTable},
  \link{standardiseCellCounts}
  }
}

\examples{
 ## Loading the example dataset:
 data(GRA)
 
 ## Selecting only one year because the function is not taking factor year automatically into account!
 GRA2009 <- GRA[GRA$Year==2009, ]
 
 ## Computing critical dates for all the trees of GRA dataset for year 2009
 GRA2009.CD <- computeCriticalDates(GRA2009, plot = TRUE)
 
 ## Creating a csv file containing computed values
 write.csv2(GRA2009.CD, file = paste("Critical dates - GRA2009 - ", Sys.Date(), ".csv", sep=""), row.names = FALSE)

}

\keyword{datagen}
\keyword{hplot}
