\name{computeGompertzCellTimings}

\alias{computeGompertzCellTimings}

\title{computeGompertzCellTimings}

\description{
 Data analysis function for computing individual cell timings from Gompertz parameters.
}

\usage{
 computeGompertzCellTimings(gompar)
}


\arguments{
 \item{gompar}{a dataframe containing three sets of Gompertz parameters (a, b, k)}
}

\details{
 This function computes cell timings using the parameters of Gompertz functions
 fitted on nELM, nLM, and nM.
}

\value{
 A data frame of at least 9 columns containing the cell number (N),
 and the computed values (tE, tL, tM, dE, dL and dT). \cr
}

\note{
 Version: 1.1-0. \cr
 Development started: 11 June 2012. \cr
 Last modifications: 19 June 2012.
}

\author{
 Cyrille Rathgeber - LERFoB, UMR1092 - INRA Nancy (France) \cr
 Email: \email{cyrille.rathgeber@inra.fr}
}

\seealso{
 \code{
  \link{aggregateRadialFiles},
  \link{computeBootstrapTest},
  \link{computeCriticalDates},
  \link{computeRingCellNb},
  \link{fitGompertzModels},
  \link{expandCellCountTable},
  \link{GRA},
  \link{overviewCellCountTable},
  \link{plotCleavelandDotChart},
  \link{plotWoodFormationCalendar},
  \link{plotWoodFormationDynamics},
  \link{plotWoodGrowth},
  \link{readExcelCountTable},
  \link{standardiseCellCounts}
  }
}

\examples{
 ## Loading the example dataset:
 #data(AMA2006)

 ## Averaging radial files for dominant firs
 ## Don't work anymore since averageRadialFiles() was replaced by aggregateRadialFiles !!!
 ## Work in progress...
 #DF <- averageRadialFiles(AMA2006[AMA2006$Sp=="ABAL" & AMA2006$Crown=="Dom", ])

 ## Compute the ring cell number to constrain the asymptote of the Gompertz
 #RCN <- computeRingCellNb(DF, stat="median")[, c("Tree", "Year", "RCN.median")]
 #names(RCN) <- c("Tree", "Year", "A")

 ## Fitting Gompertz function for nELM, nLM and nM for the dominant firs using fixed asymptotes
 #GP <- fitGompertz(DF, parameters=RCN, return.pred=FALSE, plot.fitting=FALSE, plot.OP=FALSE)

 ## Plotting Gompertz function for nELM, nLM and nM for tree 1
 #GP1 <- GP[GP$Tree==1, ]
 #GCT1 <- computeGompertzCellTimings(GP1)
}

\keyword{hplot}