\name{expandCellCountTable}

\alias{expandCellCountTable}

\title{expandCellCountTable}

\description{
   Expands a cell count table so that all the missing values are coded explicitly with NA.
}

\usage{
   expandCellCountTable(data)
}


\arguments{
   \item{data}{a data.frame containing cell count data. This data frame must contain 12 imposed variables
      with compulsory column names: Site, Year, Tree, Species, Sample, DY, RF, C, E, W, M, 
      and P (see \code{\link{GRA}}).
   }
}

\details{
   This function takes a data frame of raw cell count data (C, E, W, M, and P) recorded by radial file or 
   the aggregated values (median or mean) per tree by tree as input and expand it, 
   so that all the missing values are coded explicitly with NA.
}

\value{
   A data frame containing: \cr
   the unchanged group variables: Site, Year, Species, Tree, Sample, and DY (plus RF according to input); \cr
   and the values for variables: C, E, W, M, and P; \cr
}

\note{
 Version: 1.1-0. \cr
 Development started: 27 May 2014. \cr
 Last modifications: 28 July 2014.
}

\author{
 Cyrille Rathgeber - LERFoB, UMR1092 - INRA Nancy (France) \cr
 Email: \email{cyrille.rathgeber@inra.fr}
}

\references{
 Rathgeber C.B.K. et al. Wood formation monitoring data verification using CaviaR R package.
 \emph{in prep.}
}

\seealso{
 \code{
  \link{aggregateRadialFiles},
  \link{computeBootstrapTest},
  \link{computeCriticalDates},
  \link{computeGompertzCellTimings},
  \link{computeRingCellNb},
  \link{fitGompertzModels},
  \link{GRA},
  \link{overviewCellCountTable},
  \link{plotCleavelandDotChart},
  \link{plotWoodFormationCalendar},
  \link{plotWoodFormationDynamics},
  \link{plotWoodGrowth},
  \link{readExcelCountTable},
  \link{standardiseCellCounts}
  }
}

\examples{
   ## Loading the example dataset
   data(GRA)
   
   ## Computing the expanded data frame for GRA raw data
   GRA.exp <- expandCellCountTable(GRA)
   
   ## Computing the expanded data frame for GRA aggregated data
   GRA.med <- aggregateRadialFiles(GRA)
   GRA.med.exp <- expandCellCountTable(GRA.med)
}

\keyword{datagen}
