\name{fitGompertzModels}

\alias{fitGompertzModels}

\title{fitGompertzModels}

\description{
 fits Gompertz models to the observations.
}

\usage{
 fitGompertzModels(data, parameters = NULL, predictions = FALSE, plot.fitting = FALSE, plot.obs.vs.pre = FALSE)
}


\arguments{
 \item{data}{a data frame containing cell count data.
  This data frame must contain at least 4 columns for grouping variables with compulsory names
  (Site, Year, Tree, and Species), \cr
  and at least two columns, but potentially four, with compulsory names for date (DY), and cell count data (EWMZ, WMZ and MZ).}
 \item{parameters}{an optional data frame containing the grouping variable (Site, Year, Tree, and Species)
  and the value of the asymptotes (A - the same value will be applied for EWMZ, WMZ and MZ); \cr
  or the values of all the Gompertz parameters (a, b, k).}
 \item{predictions}{an optional bolean indicating if predicted values must be returned or not (default).}
 \item{plot.fitting}{an optional bolean indicating if a graph of the fitting must be plotted or not (default).}
 \item{plot.obs.vs.pre}{an optional bolean indicating if a verification graph must be plotted or not (default).}
}

\details{
 This function fits a Gompertz model to the observations and outputs the three fitted parameters,
  along with six biologically meaningful parameters, and three estimators of the goodness-of-fit. \cr
 The function can also outputs the predicted values. \cr
 And additionally it draws fitting and verification plots if required. \cr
 The Gompertz model is written:
 \deqn{N(t) = A e^{-e^{\beta - \kappa t}}}
 with N(t) the cumulative number of cells and t the day of year.  \cr
}

\value{
 By default a data frame containing the three fitted parameters, the six biologically meaningful parameters,
 and the three estimators of the goodness-of-fit :\cr
 \item{a}{parameter A of the model;}
 \item{b}{parameter \eqn{\beta} of the model;}
 \item{k}{parameter \eqn{\kappa} of the model;}
 \item{bG}{date at which 5 \% of the cells are produced;}
 \item{cG}{date at which 95 \% of the cells are produced;}
 \item{dG}{time elapsed between bG and cG;}
 \item{tGx}{date at which the cell production is maximal (Gompertz curve inflection point);}
 \item{rGx}{maximal rate of cell production;}
 \item{rGa}{average rate of cell production (computed between bG and cG);}
 \item{R2}{R-square;}
 \item{EF}{Modelling Efficiency;}
 \item{RMSD}{Root Mean Squared Deviation.}
 If option predictions = TRUE, a list of three data frames containing the references of the group (references),\cr
  the fitting coefficients (coefficients), and the values of observations and model predictions (values) is returned.
}

\note{
 Version: 5.2-4. \cr
 Development started: 27 November 2008. \cr
 Last modifications: 11 November 2016.
}

\author{
 Cyrille Rathgeber - LERFoB, UMR1092 - INRA Nancy (France) \cr
 Email: \email{cyrille.rathgeber@inra.fr}
}

\references{
 Rathgeber C.B.K., Rossi S.& Bontemps J.-D. 2011.
 Cambial activity related to tree size in a mature silver-fir plantation.
 \emph{Annals of Botany} \bold{108}: 429-438.
}

\seealso{
 \code{
  \link{aggregateRadialFiles},
  \link{computeBootstrapTest},
  \link{computeCriticalDates},
  \link{computeGompertzCellTimings},
  \link{computeRingCellNb},
  \link{expandCellCountTable},
  \link{GRA},
  \link{overviewCellCountTable},
  \link{plotCleavelandDotChart},
  \link{plotWoodFormationCalendar},
  \link{plotWoodFormationDynamics},
  \link{plotWoodGrowth},
  \link{readExcelCountTable},
  \link{standardiseCellCounts}
  }
}

\examples{
 ## Loading the training dataset
 data(GRA)
 
 ## Computing the mean for Grandfontaine raw data
 GRA.mean <- aggregateRadialFiles(data=GRA, stat="mean")

 ## Standardising data aggregated using the mean
 GRA.sdd <- standardiseCellCounts(GRA.mean)

 ## Computing the final total ring cell number to constrain the asymptote of the Gompertz
 GRA.sdd_RCN <- computeRingCellNb(GRA.sdd)[, c("Site", "Year", "Tree", "Species", "RCN.Median")]
 names(GRA.sdd_RCN) <- c("Site", "Year", "Tree", "Species", "A")
 
 ## Fitting Gompertz models on standardised data using fixed assymptotes, and printing verification plots in a pdf
 Plot.file.name <- paste("Verification plots for the fitting of Gompertz functions - ",
                         Sys.Date(), ".pdf", sep="")
 pdf(file = Plot.file.name)
 GRA.sdd_GZP.fix <- fitGompertzModels(GRA.sdd, parameters=GRA.sdd_RCN, predictions=FALSE,
                                      plot.fitting=TRUE, plot.obs.vs.pre=TRUE)
 dev.off()
}

\keyword{Statistical Models}
\keyword{Non-linear Regression}
\keyword{hplot}
