\name{overviewCellCountTable}
\alias{overviewCellCountTable}

\title{overviewCellCountTable}

\description{
   Check the format and provides a short summary of cell count data frame
}

\usage{
   overviewCellCountTable(data)
}

\arguments{
   \item{data}{a data.frame containing cell count data. \cr
      This data.frame must contain 12 columns
      with the qualitative variables: Site, Year, Species, Tree, Sample, DY, RF,
      and the quantitive variables CZ, EZ, WZ, MZ, and PR. (see \code{\link{GRA}}).
   }
}

\details{
   This function is designed to allow a first basic general cheking of cell count data,
   and print a short summary of factors and quantitative variables contained in the data frame.
}

\value{
   None \cr
   Information gathered by this function are directly printed in the console.
}

\note{
   Version: 1.1-1. \cr
   Development started: 22 January 2016. \cr
   Last modifications: 10 January 2017.
}

\author{
   Cyrille Rathgeber - LERFoB, INRA, AgroParisTech, F-54000, Nancy, France \cr
   Email: \email{cyrille.rathgeber@inra.fr}
}

\references{
   None
}

\seealso{
 \code{
  \link{aggregateRadialFiles},
  \link{computeBootstrapTest},
  \link{computeCriticalDates},
  \link{computeGompertzCellTimings},
  \link{computeRingCellNb},
  \link{fitGompertzModels},
  \link{expandCellCountTable},
  \link{GRA},
  \link{plotCleavelandDotChart},
  \link{plotWoodFormationCalendar},
  \link{plotWoodFormationDynamics},
  \link{plotWoodGrowth},
  \link{readExcelCountTable},
  \link{standardiseCellCounts}
  }
}

\examples{
   ## Loading the GRA dataset:
   data(GRA)
   
   ## Overview of GRA dataset
   ## -----------------------
   overviewCellCountTable(GRA)
}

\keyword{datagen}
