\name{plotCleavelandDotChart}
\alias{plotCleavelandDotChart}

\title{plotCleavelandDotChart}

\description{
 Plots Cleaveland Dot Chart for cell count data
}

\usage{
 plotCleavelandDotChart(data, show.previous.ring = TRUE)
}

\arguments{
 \item{data}{a data frame containing cell count data  with imposed column names: 
   Site, Year, Tree, Species, Sample, DY, RF, CZ , EZ, WZ, MZ, and optionally PR}
 \item{show.previous.ring}{an optional logical indicating if previous ring measurements 
   must be used (default=TRUE) or not (FALSE)}
}

\details{
 Cleaveland Dot Chart are plotted for cell count data for each phase of development,
   and for a whole data set, groupping trees per site and year automatically.
}

\value{
 A List of matrix containing lower and upper fences for each groups of trees.
}

\note{
 Version: 1.1-4. \cr
 Development started: 27 March 2014. \cr
 Last modifications: 27 June 2016.
}

\author{
 Cyrille Rathgeber - LERFoB, UMR1092 - INRA Nancy (France) \cr
 Email: \email{cyrille.rathgeber@inra.fr}
}

\references{
   Rathgeber C.B.K. Wood formation monitoring data verification using CaviaR R package.
}

\seealso{
 \code{
  \link{aggregateRadialFiles},
  \link{computeBootstrapTest},
  \link{computeCriticalDates},
  \link{computeGompertzCellTimings},
  \link{computeRingCellNb},
  \link{fitGompertzModels},
  \link{expandCellCountTable},
  \link{GRA},
  \link{overviewCellCountTable},
  \link{plotWoodFormationCalendar},
  \link{plotWoodFormationDynamics},
  \link{plotWoodGrowth},
  \link{readExcelCountTable},
  \link{standardiseCellCounts}
  }
}

\examples{
   ## Loading the GRA dataset:
   data(GRA)

   ## Looking for outliers and errors in GRA dataset
   plotCleavelandDotChart(GRA, show.previous.ring = TRUE) 

}

\keyword{hplot}
