\name{plotWoodFormationCalendar}
\alias{plotWoodFormationCalendar}

\title{plotWoodFormationCalendar}

\description{
 Plots wood formation calendar
}

\usage{
 plotWoodFormationCalendar(data, level = "Tree", main = " ", sub = " ", xlim = NULL)
}

\arguments{
 \item{data}{a data frame of critical dates and durations with
  8 compulsory columns located by their names (bE, bW, bM, cE, cW, dE, dW, dX), 
  typically output from \code{\link{computeCriticalDates}} function.
 }
 \item{level}{an optional character indicating the type of plot to draw
	 "Tree" : plot of individual critical dates for each tree of the group,\cr
	 "Group.Dates": plot of median critical dates for a group of trees,\cr
	 "Group.Durations": plot of median critical durations for a group of trees.
 }
 \item{main}{an optional character containing the plot title.
 }
 \item{sub}{an optional character containing the plot subtitle.
 }
 \item{xlim}{an optional vector indicating the x-axis minimum and maximum values.
 }
}

\details{
 Critical dates can be first plotted for each individual tree (5 trees per page) in order to allow
  a visual checking of date consistencies using \option{level = "Tree"}. \cr
 Consistent dates can then be used to draw a wood formation calendar using \option{level = "Group.Dates"}
  for critical dates and \option{level = "Group.Durations"} for critical durations. \cr
 Onsets and cessations of wood formation phenophases (i.e. enlargement: E, wall thickening: W, and
  mature: M)  are represented by diamond-crossed-by-a-line marks.
  The left end of the line represents the minimum, the left end of the diamond the first quartile,
  the middle of the diamond the median, the right end of the diamond the third quartile, and the
  right end of the line the maximum. \cr
 NB. These representations are specially designed for five trees datasets. They also work when more
 trees are available, but then the graph represents a summary of the dataset and not the individual
 data.
}

\value{
 A data frame of the critical dates and durations median and median absolute deviation.
}

\note{
 Version: 5.3-1. \cr
 Development started: 27 November 2008. \cr
 Last modifications: 11 April 2017.
}

\author{
 Cyrille Rathgeber - LERFoB, UMR1092 - INRA Nancy (France) \cr
 Email: \email{cyrille.rathgeber@inra.fr}
}

\references{
 Rathgeber C.B.K., Longuetaud F., Mothe F., Cuny H. & Le Moguedec G. 2011.
 Phenology of wood formation: Data processing, analysis and visualisation using R (Package CAVIAR).
 \emph{Dendrochronologia} \bold{29}: 139-149. \cr
}

\seealso{
 \code{
  \link{aggregateRadialFiles},
  \link{computeBootstrapTest},
  \link{computeCriticalDates},
  \link{computeGompertzCellTimings},
  \link{computeRingCellNb},
  \link{fitGompertzModels},
  \link{expandCellCountTable},
  \link{GRA},
  \link{overviewCellCountTable},
  \link{plotCleavelandDotChart},
  \link{plotWoodFormationDynamics},
  \link{plotWoodGrowth},
  \link{readExcelCountTable},
  \link{standardiseCellCounts}
  }
}

\examples{
 ## Loading the GRA dataset:
 data(GRA)
 
 ## Selecting only one year because the function is still not taking year factor into account!
 GRA2009 <- GRA[GRA$Year==2009, ]
 Fir2009 <- GRA2009[GRA2009$Sp=="ABAL", ]
 Spruce2009 <- GRA2009[GRA2009$Sp=="PCAB", ]
 Pine2009 <- GRA2009[GRA2009$Sp=="PISY", ]

 ## Computing wood formation critical dates for firs, spruces, and pines:
 Fir.CD <- computeCriticalDates(Fir2009, plot = TRUE)
 Spruce.CD <- computeCriticalDates(Spruce2009, plot = TRUE)
 Pine.CD <- computeCriticalDates(Pine2009, plot = TRUE)

 ## Visualising fir wood formation critical dates and durations on the screen:
 ## Individual dates
 plotWoodFormationCalendar(Fir.CD, level = "Tree")
 ## Dates by group of trees
 plotWoodFormationCalendar(Fir.CD, level = "Group.Dates")
 ## Durations by group of trees
 plotWoodFormationCalendar(Fir.CD, level = "Group.Durations")

 ## Plotting fir wood formation critical dates and durations in a PDF file:
 ## Opening pdf file
 pdf(file = "Fir, 2009 wood formation calendar.pdf")
 
 ## General settings for the figure
 layout(matrix(c(1, 2, 3), nrow=3, ncol=1))
 par(mar=c(4, 4, 4, 2))
 
 ## Drawing the first plot: fir 2009 individual critical dates
 plotWoodFormationCalendar(Fir.CD, level = "Tree",
                           sub = "a. Fir 2009, individual critical dates")

 ## Drawing the second plot: synthesis of fir 2009 critical dates 
 plotWoodFormationCalendar(Fir.CD, level = "Group.dates",		
                           xlim = c(100, 350), sub="b. Fir 2009 wood formation calendar", )

 ## Drawing the third plot: synthesis of fir 2009 critical durations
 plotWoodFormationCalendar(Fir.CD, level = "Group.Durations",
                           xlim = c(100, 230), sub="c. Fir 2009 wood formation durations")

 ## Closing pdf file
 dev.off()
}

\keyword{univar}
\keyword{hplot}
