\name{plotWoodGrowth}

\alias{plotWoodGrowth}

\title{plotWoodGrowth}

\description{
 Allow to plot modelled wood growth curves to cumulative cell count data for all the tree of a dataset.
}

\usage{
 plotWoodGrowth(growth.model.parameters, level="Tree", plot.by, hues, plot.title)
}

\arguments{
   \item{growth.model.parameters}{a list of elements, each containing four data frames: \cr
         (1) the references of the group (references); \cr
         (2) the fitted coefficients (coefficients); \cr
         (3) the values of observations and model predictions (values); \cr
         (4) the model simulations for every day of the year (simulations). \cr
		   This is typically the output of \link{fitGompertzModels} function.}
   \item{level}{an optional character string indicating at which plots must be drawn: \cr
         (1) option level ="Tree" (default), represents the three Gompertz curves (+ observations) for all
             individual trees; \cr
         (2) option level = "Group", represents all the individual Gompertz curves along with the mean for
             all the groups of trees; \cr
         (3) option level = "CT", represents the central tendency for all the groups of trees; \cr
         (4) option level = "Comp", compare the central tendency for selected groups of trees.}
   \item{plot.by}{a character string indicating which class must be represented on the plot (default = "Species")}
   \item{hues}{a named vector containg color hue (default = NULL)}
   \item{plot.title}{a character string containing the plot title (default = NULL)}
}

\details{
 This function plots curves describing modelled wood growth, 
 along with observed cell count data (EWMZ, WMZ, MZ) according to selected option.
}

\value{None}

\note{
 Version: 5.1-2. \cr
 Development started: 11 June 2012. \cr
 Last modifications: 16 January 2017.
}

\author{
 Cyrille Rathgeber - LERFoB, INRA, AgroParisTech, F-54000, Nancy, France \cr
 Email: \email{cyrille.rathgeber@inra.fr}
}

\seealso{
 \code{
  \link{aggregateRadialFiles},
  \link{computeBootstrapTest},
  \link{computeCriticalDates},
  \link{computeGompertzCellTimings},
  \link{computeRingCellNb},
  \link{fitGompertzModels},
  \link{expandCellCountTable},
  \link{GRA},
  \link{overviewCellCountTable},
  \link{plotCleavelandDotChart},
  \link{plotWoodFormationCalendar},
  \link{plotWoodFormationDynamics},
  \link{readExcelCountTable},
  \link{standardiseCellCounts}
  }
}

\examples{
   ## Data preparation
   ## ----------------
   ## Loading data
   data(GRA)
   
   ## Averaging Grandfontaine raw data:
   GRA.mean <- aggregateRadialFiles(data=GRA, stat="mean")
   
   ## Standardising averaged data
   GRA.sdd <- standardiseCellCounts(GRA.mean)
   
   ## Computing final total ring cell number to constrain the asymptote of the Gompertz
   GRA.sdd_RCN <- computeRingCellNb(GRA.sdd)[, c("Site", "Year", "Tree", "Species", "RCN.Median")]
   names(GRA.sdd_RCN) <- c("Site", "Year", "Tree", "Species", "A")
   
   ## Fitting the Gompertz model on standardised data using fixed assymptotes
   GRA.sdd_GZP.fix <- fitGompertzModels(GRA.sdd, parameters=GRA.sdd_RCN, predictions=TRUE,
                                        plot.fitting=FALSE, plot.obs.vs.pre=FALSE)
   
   ## Plotting Gompertz fittings using plotGompertzModels function
   ## ------------------------------------------------------------
   ## Plotting one tree
   plotWoodGrowth(GRA.sdd_GZP.fix[1])
   
   ## Plotting all the trees individually
   plotWoodGrowth(GRA.sdd_GZP.fix)
   
   ## Plotting all the trees by groups
   plotWoodGrowth(GRA.sdd_GZP.fix, level="Group")
   
   ## Plotting the means for all the groups
   plotWoodGrowth(GRA.sdd_GZP.fix, level="CT")
   
   ## Plotting the means for group of species to compare
   plotWoodGrowth(GRA.sdd_GZP.fix, level="Comp")
}

\keyword{hplot}