\name{readExcelCountTable}

\alias{readExcelCountTable}

\title{readExcelCountTable}

\description{
 Reads Excel file containing cell count data in spreadsheets
 and write the data into a database-like dataframe.
}

\usage{
 readExcelCountTable(excel.file.name,
                     tree.description.sheet.name = "Tree description",
                     sampling.description.sheet.name = "Sampling description")
}

\arguments{
 \item{excel.file.name}{a character string containing the path to the Excel file.}
 \item{tree.description.sheet.name}{an optional character string containing the name of the sheet
  to be read for tree description ("Tree description" by default).}
 \item{sampling.description.sheet.name}{an optional character string containing the name of the sheet
  to be read for sampling description ("Sampling description" by default).}
}

\details{
 This function reads Excel files containing metadata and cell count data in different spreadsheets
  and write the data into a database-like dataframe. \cr
 It first reads the tree description and the sampling description sheets of the indicated Excel file
  before to read automatically the different cell count data sheets based on the information given
  in the tree description file. \cr
 The function requires that: \cr
 \enumerate{
  \item the Excel file contains a tree description sheet, a sampling description sheet,
   and several cell count data sheets;
  \item cell count data sheets are called using the number of the tree it described,
   preceded by the word Tree (example: Tree 56);
   This number must be given in the tree description sheet;
  \item the tree description sheet contains 3 compulsory columns nammed: Tree, Site, and Species;
    other columns are discarded;
  \item the sampling description sheet contains 3 compulsory columns nammed: Sample, Year, and DY;
    other columns are discarded;
  \item a cell count data sheet must contain 16 compulsory columns, nammed:
    Sample, C1, C2, C3, E1, E2, E3, W1, W2, W3, M1, M2, M3, P1, P2, P3;
    other columns are discarded.
 }
}

\value{
 A dataframe of 12 columns containing the qualitative variables: Site, Year, Species, Tree, Sample, DY, RF,
 and the quantitive variables CZ, EZ, WZ, MZ, and PR. \cr
}

\section{Warning}{
 This function is based on the read.xls function, so it needs the gdata package to run! \cr
 \ldots The gdata package needs Perl to run.  \cr
 \ldots You may also need to install the gtools package to run the example.  \cr
}

\note{
 Version: 2.1-3. \cr
 Development started: 13 October 2010. \cr
 Last modifications: 10 January 2017.
}

\author{
   Cyrille Rathgeber - LERFoB, INRA, AgroParisTech, F-54000, Nancy, France \cr
   Email: \email{cyrille.rathgeber@inra.fr}
}

\references{
 Rathgeber C.B.K., Longuetaud F., Mothe F., Cuny H. & Le Moguedec G. 2011.
 Phenology of wood formation: Data processing, analysis and visualisation using R (Package CAVIAR).
 \emph{Dendrochronologia} \bold{29}: 139-149. \cr
}

\seealso{
 \code{
  \link{aggregateRadialFiles},
  \link{computeBootstrapTest},
  \link{computeCriticalDates},
  \link{computeGompertzCellTimings},
  \link{computeRingCellNb},
  \link{fitGompertzModels},
  \link{expandCellCountTable},
  \link{GRA},
  \link{overviewCellCountTable},
  \link{plotCleavelandDotChart},
  \link{plotWoodFormationCalendar},
  \link{plotWoodFormationDynamics},
  \link{plotWoodGrowth},
  \link{standardiseCellCounts}
  }
}

\examples{
 ## Setting the parameters of the function
 #library(gdata)

 ## Defining path names of the Excel files to be read
 GRA2007.excel.file.name <- file.path(path.package('CAVIAR'), 'extdata', 'GRA2007.xlsx')
 GRA2008.excel.file.name <- file.path(path.package('CAVIAR'), 'extdata', 'GRA2008.xlsx')
 GRA2009.excel.file.name <- file.path(path.package('CAVIAR'), 'extdata', 'GRA2009.xlsx')

 ## Reading the Excel files
 GRA2007.raw.data <- readExcelCountTable(excel.file.name = GRA2007.excel.file.name)
 GRA2008.raw.data <- readExcelCountTable(excel.file.name = GRA2008.excel.file.name)
 GRA2009.raw.data <- readExcelCountTable(excel.file.name = GRA2009.excel.file.name)

 ## Building the data frame containing the 3 years for this site
 GRA.raw.data <- rbind(GRA2007.raw.data, GRA2008.raw.data, GRA2009.raw.data)

 ## Writing GRA data frame in an external csv file
 write.csv2(GRA.raw.data, file="GRA.raw.data.csv", row.names=FALSE)
}

\keyword{datagen}
