\name{standardiseCellCounts}

\alias{standardiseCellCounts}

\title{standardiseCellCounts}

\description{
 Standardise aggregated cell count values using previous ring cell count or measurements.
}

\usage{
 standardiseCellCounts(data, na.rm = "FALSE")
}

\arguments{
 \item{data}{a data frame composed of 13 columns containing the group variables (Site, Year, Species,
             Tree, Sample, and DY; as well as the quantitative variables (CZ, EZ, WZ, MZ, PR, WMZ,
             and EWMZ. Typically, this data frame come from \code{\link{aggregateRadialFiles}} function.}
 \item{na.rm}{logical indicating if lines where PR is missing should be left as they are without applying
              any standardisation (option "FALSE" by default), or should be removed from the record (option "TRUE").}
}

\details{
 This function standardises aggregated cell counts (CZ, EZ, WZ, MZ, WMZ, EWMZ) using previous ring cell counts or
 measurements (PR). ! Insert formula here ! \cr
}

\value{
 A data frame similar to the input data frame but containing standardised values
 for the columns: CZ, EZ, WZ, MZ, WMZ, and EWMZ \cr
}

\note{
 Version: 2.1-1. \cr
 Development started: 25 January 2011. \cr
 Last modifications: 27 Septembre 2016.
}

\author{
 Cyrille Rathgeber - LERFoB, UMR1092 - INRA Nancy (France) \cr
 Email: \email{cyrille.rathgeber@inra.fr}
}

\references{
 Rathgeber C.B.K., Rossi S.& Bontemps J.-D. 2011.
 Cambial activity related to tree size in a mature silver-fir plantation.
 \emph{Annals of Botany} \bold{108}: 429-438.
}

\seealso{
 \code{
  \link{aggregateRadialFiles},
  \link{computeBootstrapTest},
  \link{computeCriticalDates},
  \link{computeGompertzCellTimings},
  \link{computeRingCellNb},
  \link{fitGompertzModels},
  \link{expandCellCountTable},
  \link{GRA},
  \link{overviewCellCountTable},
  \link{plotCleavelandDotChart},
  \link{plotWoodFormationCalendar},
  \link{plotWoodFormationDynamics},
  \link{plotWoodGrowth},
  \link{readExcelCountTable}
  }
}

\examples{
 ## Loading the training dataset
 data(GRA)
 
 ## Computing the median for Grandfontaine raw data
 GRA.med <- aggregateRadialFiles(data=GRA, stat="median")

 ## Standardising aggregated data, with keeping in data that cannot be standardised
 GRA.med.sdd1 <- standardiseCellCounts(GRA.med)

 ## Standardising aggregated data, and removing data that can not standardised
 GRA.med.sdd2 <- standardiseCellCounts(GRA.med, na.rm = "TRUE")

 ## Creating a csv file containing critical dates data
 write.csv2(GRA.med.sdd1, file = paste("GRA median standardised ", Sys.Date(), ".csv", sep=""), row.names = FALSE)
}

\keyword{datagen}
